-- Huge thanks to Blocky.cmd for this Custom Pause Menu template, modified by Jzzay.

if unsupported then return end

local zero = {x=0,y=0,z=0}
local m = gMarioStates[0]
local np = gNetworkPlayers[0]
local restartLevelArea = 1

isPaused = false

--* thanks coolio for the hook & function overwriting

local function is_game_paused_modded()
    return isPaused
end

_G.is_game_paused = is_game_paused_modded

local pause_exit_funcs = {}

local real_hook_event = hook_event
local function hook_event_modded(hook, func)
    if hook == HOOK_ON_PAUSE_EXIT then
        table.insert(pause_exit_funcs, func)
    else
        return real_hook_event(hook, func)
    end
end
_G.hook_event = hook_event_modded

local function call_pause_exit_hooks(exitToCastle)
    local allowExit = true
    for _, func in ipairs(pause_exit_funcs) do
        if func(exitToCastle) == false then
            allowExit = false
            break
        end
    end
    return allowExit
end

local play_sound,save_file_get_star_flags,level_trigger_warp,warp_to_warpnode,djui_hud_set_resolution,djui_hud_set_font,
      djui_hud_get_screen_height,djui_hud_get_screen_width,djui_hud_set_color,djui_hud_render_rect,course_is_main_course,get_level_name,
      get_star_name,save_file_get_course_star_count,get_current_save_file_num,save_file_get_course_coin_score,djui_hud_measure_text,
      djui_hud_print_text,obj_count_objects_with_behavior_id,djui_open_pause_menu =
      play_sound,save_file_get_star_flags,level_trigger_warp,warp_to_warpnode,djui_hud_set_resolution,djui_hud_set_font,
      djui_hud_get_screen_height,djui_hud_get_screen_width,djui_hud_set_color,djui_hud_render_rect,course_is_main_course,get_level_name,
      get_star_name,save_file_get_course_star_count,get_current_save_file_num,save_file_get_course_coin_score,djui_hud_measure_text,
      djui_hud_print_text,obj_count_objects_with_behavior_id,djui_open_pause_menu

local selectedOption = 1

local function close_menu()
    if isPaused then
        isPaused = false
        play_sound(SOUND_MENU_PAUSE_HIGHPRIO, zero)
        m.controller.buttonPressed = 0
    end
end

local cooldown = 5
local cooldownCounter = 0

local previousStickY = 0

function loop_var(var, min, max)
    if var > max then
        var = min
    elseif var < min then
        var = max
    end
    return var
end

local function menu_controls(options)
    local stickY = gMarioStates[0].controller.stickY

    if stickY * previousStickY <= 0 then
        cooldownCounter = cooldownCounter // 2
    end

    if cooldownCounter > 0 then
        cooldownCounter = cooldownCounter - 1
    else
        local delta = options and 1 or -1
        if stickY > 0.5 or gMarioStates[0].controller.buttonPressed & U_JPAD ~= 0 then
            selectedOption = (selectedOption - delta)
            if options then
                selectedOption = loop_var(selectedOption, 1, #options)
            else
                selectedOption = loop_var(selectedOption, 0, COURSE_MAX)
            end
            play_sound(SOUND_MENU_CHANGE_SELECT, zero)
            cooldownCounter = cooldown
        elseif stickY < -0.5 or gMarioStates[0].controller.buttonPressed & D_JPAD ~= 0 then
            selectedOption = (selectedOption + delta)
            if options then
                selectedOption = loop_var(selectedOption, 1, #options)
            else
                selectedOption = loop_var(selectedOption, 0, COURSE_MAX)
            end
            play_sound(SOUND_MENU_CHANGE_SELECT, zero)
            cooldownCounter = cooldown
        end
    end

    if gMarioStates[0].controller.buttonPressed & A_BUTTON ~= 0 and options then
        play_sound(SOUND_MENU_CLICK_FILE_SELECT, gMarioStates[0].pos)
        local option = options[selectedOption]
        if option and option.func then
            option.func()
        end
    end

    previousStickY = stickY
end

local romhackText = ""

for i, mod in pairs(gActiveMods) do
    if mod.enabled then
        if mod.incompatible and mod.incompatible:find("romhack") then
            if romhackInfo == nil then
                romhackText = string_without_hex(mod.name)
            else
                romhackText = string_without_hex(romhackInfo)
            end
        end
    end
end

-- Start Rounds
local function start_round()
    if call_pause_exit_hooks(false) then
        if network_is_server() then
            if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
                close_menu()
                play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
                round_start()
            elseif gGlobalSyncTable.mapMode == MAPMODE_RANDOM then
                gGlobalSyncTable.level = math.random(#gLevels)
                level_restart()
                gGlobalSyncTable.totalRoundRestarts = 0
            end
        else
            djui_popup_create("Unable to perform this action!", 1)
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        end
    end
end

-- Restart Rounds
local function restart_round()
    if call_pause_exit_hooks(false) then
        if network_is_server() then
            if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                close_menu()
                play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
                network_send(true, { restart = true })
                level_restart()
            end
        else
            djui_popup_create("Unable to perform this action!", 1)
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        end
    end
end

-- Skip Rounds
local function skip_round()
    if call_pause_exit_hooks(false) then
        if network_is_server() then
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
            round_skip()
        else
            djui_popup_create("Unable to perform this action!", 1)
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        end
    end
end

-- Stop Rounds
local function stop_round()
    if call_pause_exit_hooks(false) then
        if network_is_server()
        or network_is_moderator() then
            if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                close_menu()
                play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
                round_end()
                if gPlayerSyncTable[0].finished then
                    gGlobalSyncTable.level = gGlobalSyncTable.level + 1
		        end
            end
        else
            djui_popup_create("Unable to perform this action!", 1)
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        end
    end
end

-- Set Spectator
local function set_spectator()
    if call_pause_exit_hooks(false) then
        if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE and network_player_connected_count() > 1 then
            close_menu()
            play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
            set_mario_spectator(m)
        end
    else
        djui_popup_create("Unable to perform this action!", 1)
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
    end
end

-- Coop Settings
local function coop_settings()
    if call_pause_exit_hooks(false) then
        close_menu()
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        djui_open_pause_menu()
    end
end

-- Flood Settings
local function flood_settings()
    if call_pause_exit_hooks(false) then
        close_menu()
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
        showSettings = not showSettings
        if true then return true end
    else
        djui_popup_create("Unable to perform this action!", 1)
        play_sound(SOUND_MENU_CAMERA_BUZZ, zero)
    end
end

local pauseMenuLevelOptions = {
    {name = "Continue"      , func = close_menu},
}

local function open_cs()
    _G.charSelect.set_menu_open(true)
    close_menu()
end

local function render_options(options, screenHeight, screenWidth, optionPosY)
    local arrowUp = ""
    local arrowDown = ""
    if #options > 4 then
        if selectedOption > 4 then
            arrowUp = "^"
        end
        if selectedOption <= #options - 1 then
            arrowDown = "v"
        end
    end

    local startOptionIndex = math.max(selectedOption - 3, 1)
    local endOptionIndex = math.min(startOptionIndex + 3, #options)

    for i = startOptionIndex, endOptionIndex do
        local option = options[i]
        local optionNameLength = djui_hud_measure_text(option.name)
        local optionPosX = screenWidth * 0.5 - optionNameLength * 0.5

        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_print_text(option.name, optionPosX + 1, optionPosY + 1, 1)
        djui_hud_set_color(255, 255, 255, 255)

        if i == selectedOption then
            djui_hud_set_color(0, 0, 0, 128)
            djui_hud_print_text(">", optionPosX - 15, optionPosY + 1, 1)
            djui_hud_set_color(255, 255, 255, 255)
            djui_hud_print_text(">", optionPosX - 16, optionPosY, 1)
        end

        djui_hud_print_text(option.name, optionPosX, optionPosY, 1)
        optionPosY = optionPosY + 20
    end

    local arrowUpPosY = screenHeight * 0.55 - 10
    local arrowDownPosY = screenHeight - 30
    local arrowDownPosX = screenWidth * 0.5 - djui_hud_measure_text(arrowDown) * 0.5
    local arrowUpPosX = screenWidth * 0.5 - djui_hud_measure_text(arrowUp) * 0.5

    if arrowUp ~= "" then
        djui_hud_print_text(arrowUp, arrowUpPosX, arrowUpPosY, 1)
    end
    if arrowDown ~= "" then
        djui_hud_print_text(arrowDown, arrowDownPosX, arrowDownPosY, 1)
    end
end

local function render_text(text)
    for _, data in ipairs(text) do
        djui_hud_set_font(data.font)
        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_print_text(data.text, data.posX + 1, data.posY + 1, 1)
        if data.color then
            djui_hud_set_color(data.color.r, data.color.g, data.color.b, data.color.a)
        else
            djui_hud_set_color(255, 255, 255, 255)
        end
        djui_hud_print_text(data.text, data.posX, data.posY, 1)
    end
end

local function hud_render()
    if not isPaused then return end

    if network_is_server() or network_is_moderator() then
        local specialOptionsExist = true
        for _, option in ipairs(pauseMenuLevelOptions) do
            if option.name == "Start Round"
            or option.name == "Restart Round"
            or option.name == "Stop Round" then
                specialOptionsExist = false
                break
            end
        end
        if specialOptionsExist then
            table.insert(pauseMenuLevelOptions, {name = "Start Round" , func = start_round})
            table.insert(pauseMenuLevelOptions, { name = "Restart Round", func = restart_round })
            table.insert(pauseMenuLevelOptions, {name = "Skip Round" , func = skip_round})
            table.insert(pauseMenuLevelOptions, {name = "Stop Round" , func = stop_round})
        end
    end

    local normalOptionsExist = true
    for _, option in ipairs(pauseMenuLevelOptions) do
        if option.name == "Set Spectator"
        or option.name == "Coop Settings"
        or option.name == "Flood Settings" then
            normalOptionsExist = false
            break
        end
    end
    if normalOptionsExist then
        table.insert(pauseMenuLevelOptions, {name = "Set Spectator"   , func = set_spectator})
        table.insert(pauseMenuLevelOptions, {name = "Coop Settings", func = coop_settings})
        table.insert(pauseMenuLevelOptions, {name = "Flood Settings", func = flood_settings})
    end

    -- Character Select Support
    if _G.charSelectExists then
        local csOptionExists = false
        for _, option in ipairs(pauseMenuLevelOptions) do
            if option.name == "Character Select" then
                csOptionExists = true
                break
            end
        end
        if not csOptionExists then
            table.insert(pauseMenuLevelOptions, {name = "Character Select", func = open_cs})
        end
        if isPaused and _G.charSelect.is_menu_open() then
            close_menu()
        end
        if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
            if network_is_server() or network_is_moderator() then
                table.remove(pauseMenuLevelOptions, 9)
            else
                table.remove(pauseMenuLevelOptions, 6)
            end
        end
    end

    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_TINY)
    local theme = get_selected_theme()
    local screenHeight = djui_hud_get_screen_height()
    local screenWidth = djui_hud_get_screen_width()
    local optionPosY = screenHeight * 0.55

    djui_hud_set_color(theme.pauseBackground.r, theme.pauseBackground.g, theme.pauseBackground.b, theme.pauseBackground.a)
    djui_hud_render_rect(0, 0, screenWidth + 20, screenHeight)
    djui_hud_set_color(255, 255, 255, 255)

    m.freeze = 1
    showSettings = false

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        local levelName = name_of_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, gLevels[gGlobalSyncTable.level].name, gLevels[gGlobalSyncTable.level])
        local textPositions = {
            { text = levelName,   font = FONT_TINY, posX = screenWidth * 0.5 - djui_hud_measure_text(levelName) * 0.5,   posY = optionPosY - 40 },
            { text = "PAUSE",     font = FONT_HUD,  posX = screenWidth * 0.5 - djui_hud_measure_text("PAUSE"),           posY = optionPosY - 80 },
            { text = romhackText, font = FONT_NORMAL,  posX = screenWidth * 0.5 - djui_hud_measure_text(romhackText),    posY = optionPosY - 120},
        }

        render_text(textPositions)

        djui_hud_set_font(FONT_TINY)

        if (gLevelValues.pauseExitAnywhere or (gMarioStates[0].action & ACT_FLAG_PAUSE_EXIT) ~= 0) then
            menu_controls(pauseMenuLevelOptions)
            render_options(pauseMenuLevelOptions, screenHeight, screenWidth, optionPosY)
        end

        djui_hud_set_font(eHudVariables.font)

        djui_hud_print_text(eHudVariables.font == FONT_MENU and "Current Level: " .. gGlobalSyncTable.level .. " /" .. FLOOD_LEVEL_COUNT or "Current Level: " .. gGlobalSyncTable.level .. "/" .. FLOOD_LEVEL_COUNT, eHudVariables.font == FONT_MENU and djui_hud_get_screen_width() / 180 or eHudVariables.font == FONT_HUD and djui_hud_get_screen_width() / 200 or djui_hud_get_screen_height() / 65, 228, eHudVariables.font == FONT_MENU and 0.20 or eHudVariables.font == FONT_HUD and 0.60 or 0.40)

        djui_hud_print_text(eHudVariables.font == FONT_MENU and "Total Restarts: " .. gGlobalSyncTable.totalRoundRestarts or "Total Restarts: " .. gGlobalSyncTable.totalRoundRestarts, eHudVariables.font == FONT_MENU and djui_hud_get_screen_width() / 180 or eHudVariables.font == FONT_HUD and djui_hud_get_screen_width() / 200 or djui_hud_get_screen_height() / 65, 218, eHudVariables.font == FONT_MENU and 0.20 or eHudVariables.font == FONT_HUD and 0.60 or 0.40)
        elseif gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then
        local levelName = "Lobby"
        local textPositions = {
            { text = levelName,   font = FONT_TINY, posX = screenWidth * 0.5 - djui_hud_measure_text(levelName) * 0.5,   posY = optionPosY - 40 },
            { text = "PAUSE",     font = FONT_HUD,  posX = screenWidth * 0.5 - djui_hud_measure_text("PAUSE"),           posY = optionPosY - 80 },
            { text = romhackText, font = FONT_NORMAL,  posX = screenWidth * 0.5 - djui_hud_measure_text(romhackText),       posY = optionPosY - 120},
        }

        render_text(textPositions)

        djui_hud_set_font(FONT_TINY)
        if (gLevelValues.pauseExitAnywhere or (gMarioStates[0].action & ACT_FLAG_PAUSE_EXIT) ~= 0) then
            menu_controls(pauseMenuLevelOptions)
            render_options(pauseMenuLevelOptions, screenHeight, screenWidth, optionPosY)
        end

        djui_hud_set_font(eHudVariables.font)

        if eHudVariables.nextLevelIndicator then
            djui_hud_print_text(gGlobalSyncTable.mapMode ~= MAPMODE_NORMAL and "Next Level: ???" or "Next Level: " .. name_of_level(gLevels[gGlobalSyncTable.level].level, gLevels[gGlobalSyncTable.level].area, gLevels[gGlobalSyncTable.level].name, gLevels[gGlobalSyncTable.level]), eHudVariables.font == FONT_MENU and djui_hud_get_screen_width() / 180 or eHudVariables.font == FONT_HUD and djui_hud_get_screen_width() / 200 or djui_hud_get_screen_height() / 65, 228, eHudVariables.font == FONT_MENU and 0.20 or eHudVariables.font == FONT_HUD and 0.60 or 0.40)
        end
    end

    -- Credits to TOÑO for the romhack logos
    if romhackLogo ~= nil and eHudVariables.romhackLogos then
        djui_hud_set_adjusted_color(255, 255, 255, 255)
        djui_hud_render_texture(romhackLogo, 15, 170, 0.6, 0.4)
    end
end

local function pressed_pause()
    if get_dialog_id() >= 0 or (_G.charSelectExists and _G.charSelect.is_menu_open()) then
        return false
    end

    return gMarioStates[0].controller.buttonPressed & START_BUTTON ~= 0
end

function before_mario_update()
    local rTrigPressed = m.controller.buttonPressed & R_TRIG ~= 0

    if pressed_pause() then
        if not isPaused then
            isPaused = true
            selectedOption = 1
            m.controller.buttonPressed = 0
            play_sound(SOUND_MENU_PAUSE_HIGHPRIO, zero)
        else
            close_menu()
        end
    elseif rTrigPressed and isPaused then
        djui_open_pause_menu()
        m.controller.buttonPressed = 0
        play_sound(SOUND_MENU_EXIT_A_SIGN, zero)
    end
end

real_hook_event(HOOK_ON_HUD_RENDER, hud_render)
real_hook_event(HOOK_BEFORE_MARIO_UPDATE, before_mario_update)
real_hook_event(HOOK_ON_WARP, close_menu)
real_hook_event(HOOK_ON_LEVEL_INIT, function () restartLevelArea = gNetworkPlayers[0].currAreaIndex close_menu() end)
